;; -*- Mode:Common-Lisp; Package:MACTOOLBOX; Base:10; Fonts:(CPTFONT HL10B HL12I CPTFONT CPTFONTB) -*- 

;1;; INSTRUCTIONS for EXAMPLES in this FILE:*
;1;;     *  Compile and load this file.  For example, if you are reading this in a Zmacs buffer, then use META-Z.*
;1;;         Also, see Implementation Note after the REQUIRE form below.*
;1;;     *  Make sure the default TB Server is running, enter *(tb:launch-default-tb-server t)1 in a*
;1;;         listener.  (You will have to click on the microExplorer window to reselect it after the launch.)*
;1;;     * Shrink the microExplorer window until it occupies the lower half of the screen leaving the upper half*
;1;;         free for the window  some of these examples create.*
;1;;     * Enter *(tb:2example-name*)1 in a listener*
;1;;     * If the example puts up its own window, then click on it to select the TB Server.*
;1;;        If the example does NOT put up its own window (e.g., the menu examples) then following the*
;1;;        instructions printed in the Listener and click on the "tbserver" item from the Apple Menu in the*
;1;;        Menu Bar to see your example.*
;1;;     * The best way to tell when your example is running is to what the Menu Bar change.*
;1;;     * After you have clicked on "Quit" in the File Menu on the Menu Bar, you will have to click on the*
;1;;        microExplorer window to reselect it.*


(require  "TOOLBOX-MACROS" "SYS:PUBLIC-MX;TOOLBOX-MACROS")
;1;; IMPLEMENTATION NOTE:  This file requires macros in the TOOLBOC-MACROS file of the PUBLIC-MX*
;1;; directory (the same directory this file normally resides in).  The above REQUIRE form should load the*
;1;; macro file automatically.  However, if you are keeping your files in non-standard places, you will have to*
;1;; load the macro file yourself.*



;1;;; 4DRAWING METHODS EXAMPLE**
(defun 4EXAMPLE-DRAWING* (&optional (sleep-time 3))
  (declare (values ignore))
  
  ;1; Open a window and make it the current port.*
  (with-cWindow (window :title "3Example Drawing*")
    ;1; IMPLEMENTATION NOTE:  The macros such s WITH-CWINDOW, WITH-CWINDOW-RES,*
    ;1; WITH-WINDOW, and WITH-WINDOW-RES are the much preferred way to create, use, and dispose of*
    ;1; a temporary window.  A new window of the appropriate variety is created use the macro arguments.*
    ;1; A  symbol (*window1, in this case) is bound to it.  Finally, the new window is made to be the current*
    ;1; port for drawing withing the body of the macro (the following *let1, in this case).*
    ;1;*
    ;1; Upon normal or abnormal exit from the body, the previous port is restored and the new window is*
    ;1; disposed of thereby freeing all associated Macintosh memory.  If you had specified the :WSTORATE*
    ;1; argument for the window (i.e., the new window is to use previously allocated memory and will*
    ;1; presumably be used again elsewhere) then the new window is merely closed which frees up it new*
    ;1; contents but does not free up the window itself.*
    ;1;*
    ;1; PROGRAMMING NOTE:  'C' Windows (i.e., windows built on color grafPorts) should be used for all*
    ;1; new work--even when the window is to be displayed on a monochrome screen.*

    (sleep 1)
    (let ((rect      (make-instance 'Rect :left 40 :top 10 :right 130 :bottom 40))
	  (oval      (make-instance 'Oval :left 150 :top 10 :right 240 :bottom 40))
	  (roundrect (make-instance 'RoundRect :left 260 :top 10 :right 350
				    :bottom 40)))
      ;1; tell each object to frame itself, paint itself, and invert itself with a short wait in between*
      (dolist (message '(:frame :paint :invert))
	(send rect message)
	(sleep 1)
	(send oval message)
	(sleep 1)
	(send roundrect message)
	(sleep 1)
	(send rect :offset 0 40)
	(send oval :offset 0 40)
	(send roundrect :offset 0 40)
	(sleep sleep-time))
      );1;let
          *);1;with-window
    *);1;example-drawing*



;1;;; 4POLYGON EXAMPLE**
(defun 4EXAMPLE-POLYGON *(&optional (sleep-time 5))
  (declare (values ignore))
  
  (with-cWindow (window :title "3Example Polygon*")
    (with-instance (poly Polygon)
      ;1; IMPLEMENTATION NOTE:  The WITH-INSTANCE macro is a convenient way to create a temporary*
      ;1; instance of a flavor during the execution of a body of code and then dispose of it upon normal*
      ;1; or abnormal exit from the body.  This macro can be used only with flavors which accept a*
      ;1; :DISPOSE message (e.g., PixPat, Region, PixMap, Polygon, Picture, etc.).*
      ;1;*
      ;1; In addition, certain flavors (e.g., Region, Polygon, Picture) carry warnings that only one can be*
      ;1; open at one time.  If you always use this macro to create instances of these flavors, it will signal*
      ;1; a  MULTIPLE-OPEN-INSTANCE-ERROR error if more than one instance is created at run time.  It*
      ;1; cannot, however, detect duplicates of these instances created in other manners (e.g., by direct*
      ;1; MAKE-INSTANCE).

             *;1;  Define the polygon.  We will define an unusually shaped concave one.*
      (!MoveTo 100 10)
      (!LineTo 150 10)
      (!LineTo  60 50)
      (!LineTo 150 90)
      (!LineTo 100 90)
      (!LineTo 100 10)

      ;1; PROGRAMMING NOTE:  The code between the WITH-INSTANCE and the !ClosePoly act to define*
      ;1; the polygon.  During this phase, QuickDraw accumulates information about the object you are*
      ;1; defining (in thie case, a polygon).  The !ClosePoly tells QuickDraw to take what its got and make a*
      ;1; graphics object out of it.  The code after the !ClosePoly simply operates of the "pre-defined"*
      ;1; graphics objects.*
      (!ClosePoly)

1              *;1;  Now that the polygon is defined, Quickdraw can perform a number of operations on it.*
      (dolist (message '(:frame :paint :invert))
	(send Poly message)
	(send Poly :offset 100 0)
	(sleep 1))
      (send Poly :fill !dkgray)

      ;;1  Sleep for a few seconds, so we have time to admire our handiwork, then exit.*
      (sleep sleep-time)))
  );1;example-polygon*



;1;;; 4PICTURE EXAMPLES**
(defun 4EXAMPLE-PICTURE *(&optional (sleep-time 5))
  (with-cwindow (window :title "3Example Picture*")
1        *;1;  Make the clipRgn small, so !DrawPicture will work.*
    (!ClipRect (send window :portRect))
    (let ((frame      (make-instance 'rect :left 10 :top 10 :right 60 :bottom 60))
	  (oval       (make-instance 'oval :left 10 :top 10 :right 60 :bottom 60))
	  (DrawFrame1 (make-instance 'Rect
				     :left 100 :top 10 :right 120 :bottom 30))
	  (DrawFrame2 (make-instance 'Rect
				     :left 100 :top 50 :right 140 :bottom 90))
	  (DrawFrame3 (make-instance 'Rect
				     :left 160 :top 10 :right 250 :bottom 60)))
      (with-instance (picture Picture :picframe frame)
	;1;  Draw the picture.  Notice that this does not actually draw anything on the screen.*
	(dotimes (i 5)
	  (send oval :fill !black)
	  (send oval :inset 3 3)
	  (send oval :erase)
	  (send oval :inset 3 3))
	
      ;1; PROGRAMMING NOTE:  The code between the WITH-INSTANCE and the !ClosePicture act to*
      ;1; define the picture.  During this phase, QuickDraw accumulates information about the object you*
      ;1; are defining (in thie case, a picture).  The !ClosePicture tells QuickDraw to take what its got and*
      ;1; make a graphics object out of it.  The code after the !ClosePicture simply operates of the "pre-de*
      ;1; "pre-defined" graphics objects.*
	(!ClosePicture)

	;1;  Redraw the picture in three different locations, in three different sizes.*
	(!DrawPicture picture DrawFrame1)
	(!DrawPicture picture DrawFrame2)
	(!DrawPicture picture DrawFrame3)

	;1; wait a few seconds to admire our handy work and then return*
	(sleep sleep-time))))
  );1;example-picture*



;1;;; 4MENU EXAMPLE**
(defun 4EXAMPLE-MENU *()
  (declare (values ignore))
  (with-menus ((FileMenu FileMenuID :menuID 128 :title "3File*")
	       (EditMenu EditMenuID :menuID 129 :title "3Edit*"))
    (initialize-example-menu FileMenu EditMenu)
    (with-menu-bar (FileMenu EditMenu)
      (format t
	"3~%TB:EXAMPLE-MENU is now running*.  3Pull down *the Apple Menu in the3 *Menu3~*
 3        ~%BAR *and 3then select \"tbserver\" at the bottom to see your example File~
         ~%and Edit menus.*")

1              *;1; Main Event Loop*
      (loop-on-event (:sleep 1)
1                  *;1; PROGRAMMING NOTE:  The *:SLEEP 11 argument to LOOP-ON-EVENT says to return as soon 
                  *;1; as any* 1event occurs (remember, the event mask is !everyEvent) -OR- return after one 'TICK'
                  *;1; (1/60-th of a* 1second) has elapsed, whichever comes first.*
    
	(#.!mouseDown (example-menu-mousedown-handler event 1))
	;1;  IMPLEMENTATION NOTE:  This example only needs to worry about mouseDown events, so *
	;1; there are no other event handled here.*
	(otherwise (ignore)))
      ;1; IMPLEMENTATION NOTE:  This LOOP-ON-EVENT macro does not need a cleanup clause*
      ;1; the only cleanup required is for the menus and the WITH-MENUS and WITH-MENU-BAR macros*
      ;1; are doing that for us.  If you use these macros, you should only need a separate cleanup clause*
      ;1; to handle application-specific cleanup.*
      ))
  ;1; PROGRAMMING NOTE:  At this point, the example menu "application" has quit and cleared the Menu *
  ;1; Bar, but the microExplorer application has not yet been re-selected (i.e., the micorExplorer window *
  ;1; title bar is not highlighted and the window will not accept keyboard input).  The following function*
  ;1; call re-selects the microExplorer window.*
  (select-application)
  nil
  );1;example-menu*


(defun 4INITIALIZE-EXAMPLE-MENU *(FileMenu EditMenu)
  "2create menus and put them into the Menu Bar*"
  (declare (values ignore))

  ;1; PROGRAMMING NOTE:  Your menus should always include the standard Apple Menu at the left end*
  ;1; of the Menu Bar.  This Apple Menu should list all available desk accessories as well as an "About..."*
  ;1; item at the top of the menu which describes your application (e.g., name, version number, copyright*
  ;1; notice, etc.).*
  ;1;*
  ;1; However 2this*  example takes tutorial license with the Macintosh standards and, for the sake of*
  ;1; simplicity, does 2not*  include the standard Apple Menu.  The EXAMPLE-SHELL example in the*
  ;1; PUBLIC-MX shows how to set up the Apple Menu.*

  ;1; IMPLEMENTATION NOTE:  In traditional Macintosh applications, the "initialize menus" subprogram*
  ;1; first defines the menus with !NewMenu or !GetMenu; then adds items to these menus with*
  ;1; !AppendMenu and !AddResMenu; and finally redraws the Menu Bar with these newly defined menus.*
  ;1; A separate cleanup procedure disposed of the menus and clears the Menu Bar.*
  ;1;*
  ;1; If you use the WITH-MENUS and WITH-MENU-BAR macros, then the only things left for an initialize*
  ;1; menu function to do is to load up menu items...which is what this function is doing now.  There is no*
  ;1; need for a cleaup procedure that only cleans up menus.  Also, there is no longer a need to the global*
  ;1; DEFVARs and DEFCONSTANTs for menu handles and menu IDs.*
  
  ;1; FILE*
  (!AppendMenu FileMenu "Quit")
  ;1; This creates a menu named "File" with one item named "Quit"*

  ;1; EDIT*
  (!AppendMenu EditMenu "Undo;(-;Cut;Copy;Paste")
  ;1; IMPLEMENTATION NOTE:  Remember, the text string to !AppendMenu is really a mini-language.*
  ;1; Semicolons separate vertical menu items, hyphens specify a horizontal dividing line between items,*
  ;1; and a left parentheses make the next item unselectable.  Therefore this menu, named "Edit", will look*
  ;1; something like this:*
  ;1;*
  ;1;*	1Undo*
  ;1;*	1--------      <-- line will be dimmed because it is not selectable*
  ;1;*	1Cut*
  ;1;*	1Copy*
  ;1;*	1Paste*
  ;1;*
  ;1; Of course, selecting one of these will have no effect since we haven't provided any code support for*
  ;1; them.*
  );1; initialize-example-menu*


(defun 4EXAMPLE-MENU-MOUSEDOWN-HANDLER *(event QuitItem)
  "2handle all mouseDown events for both EXAMPLE-MENUS and
EXAMPLE-HMENUS examples.*"
  (declare (special FileMenuID))
  ;1; IMPLEMENTATION NOTE:  The "Quit" menu item number is passed in as an argument to this function*
  ;1; rather than being a declared constant so that this function can server two examples which have*
  ;1; a need for distinct "Quit" item numbers.*
  
  ;1; first, find out where the mouse was clicked*
  (multiple-value-bind (partcode whichWindow)
      (FindWindow event)
    (declare (ignore whichWindow))	       ;1there's only one window of interest*
    (case (the fixnum partcode)
      (#.!inMenuBar			       ;1in a menu*
       ;1; second, find out which item of which menu*
       (multiple-value-bind (whichMenu whichItem)
	   (!MenuSelect event)
	1 *;1;  Here is where we take any appropriate action based on whatever menu* 1item was selected.*
	1 *;1;This usually means calling functions that execute each possible menu command, but in this*
	1 *;1; example we only check if the user selected Quit from the file menu.*
	 (if (and (= whichMenu FileMenuID)
		  (= whichItem QuitItem))
	1            *;1; then he did click on "Quit" in the "File" menu, so exit event loop*
	     (throw 'EVENT-LOOP-EXIT nil)

	     ;1; else he clicked elsewhere, so just unhighlight the menu and return*
	     (!HiliteMenu 0))))
1              *;1;  In this example we only care about mouseDowns in the menu bar, but other mouseDowns could*
      ;1;be checked for here.*
      (otherwise (ignore))))
  );1;example-menu-mouseDown-handler*



;1;; 4HIERARCHICAL MENU EXAMPLE**
(defun 4EXAMPLE-HMENU *()
  (declare (values ignore))
  (with-menus ((FileMenu FileMenuID :menuID 128 :title "3File*")
	       (EditMenu EditMenuID :menuID 129 :title "3Edit*")
	       (HMenu    HMenuID    :menuID 130))
    (initialize-example-hmenus FileMenu EditMenu HMenu)
    (with-menu-bar (FileMenu EditMenu (HMenu HMenuID FileMenu 1))
      (format t
	"3~%TB:EXAMPLE-HMENU is now running*.  3Pull down *the Apple Menu in the3 *Menu Bar3~*
 3        ~%*and 3then select \"tbserver\" at the bottom to see your example File and~
         ~%Edit menus.*")

      (loop-on-event (:sleep 1)
	(#.!mouseDown (example-menu-mouseDown-handler event 2))
	;1NOTE: the mouseDown handler is the same as the one in EXAMPLE-MENU above*
	(otherwise    (ignore)))
1              *;1; IMPLEMENTATION NOTE:  This LOOP-ON-EVENT macro does not need a cleanup clause*
      ;1; the only cleanup required is for the menus and the WITH-MENUS and WITH-MENU-BAR macros*
      ;1; are doing that for us.  If you use these macros, you should only need a separate cleanup clause*
      ;1; to handle application-specific cleanup.*
      ))
  ;1; PROGRAMMING NOTE:  At this point, the example menu "application" has quit and cleared the Menu *
  ;1; Bar, but the microExplorer application has not yet been re-selected (i.e., the micorExplorer window *
  ;1; title bar is not highlighted and the window will not accept keyboard input).  The following function*
  ;1; call re-selects the microExplorer window.*
  (select-application)
  nil
  );1;example-hmenus*


(defun 4INITIALIZE-EXAMPLE-HMENUS *(FileMenu EditMenu HMenu)
  "2create the menus*"
1    *;1;  File
    *;1;  The first item of the File menu will have a hierarchical menu.*
  (!AppendMenu FileMenu "Test Hierarchical Item;Quit")

1     *;1;  Edit*
  (!AppendMenu EditMenu "Undo;(-;Cut;Copy;Paste")

1     *;1;  Hierarchical Menu.*
  (!AppendMenu HMenu "One;Two;Three")
  );1;initialize-example-hmenus
